<?php
// chatwoot-whmcs-bridge.php

require __DIR__ . '/init.php';

$raw = file_get_contents('php://input');
$data = json_decode($raw, true);

if (!$data || empty($data['event'])) {
    http_response_code(400);
    exit('Invalid payload');
}

if ($data['event'] === 'message_created') {
    $message = $data['content'];
    $conversationId = $data['conversation']['id'];
    $senderType = $data['message_type']; // incoming/outgoing
    $contactEmail = $data['contact']['email'] ?? null;

    if ($senderType === 'outgoing' && $contactEmail) {
        // Find WHMCS client
        $client = Capsule::table('tblclients')->where('email', $contactEmail)->first();

        if ($client) {
            // Find existing ticket or create new
            $ticket = Capsule::table('tbltickets')
                ->where('userid', $client->id)
                ->orderBy('id', 'desc')
                ->first();

            if ($ticket) {
                // Add reply
                localAPI('AddTicketReply', [
                    'ticketid' => $ticket->id,
                    'message'  => $message,
                    'admin'    => 'Chatwoot Agent'
                ]);
            } else {
                // Create new ticket if none found
                localAPI('OpenTicket', [
                    'clientid' => $client->id,
                    'deptid'   => 1,
                    'subject'  => 'Chatwoot Conversation #' . $conversationId,
                    'message'  => $message,
                    'priority' => 'Medium'
                ]);
            }
        }
    }
}

http_response_code(200);
echo 'OK';
