<?php
require_once 'config.php';

header('Content-Type: application/json');

try {
    if (!isset($pdo) || !($pdo instanceof PDO)) {
        echo json_encode(['error' => 'Database connection not initialized.']);
        exit;
    }

    $region = $_POST['region'] ?? '';
    if ($region) {
        $stmt = $pdo->prepare("SELECT DISTINCT county FROM schools WHERE region = :region AND county IS NOT NULL ORDER BY county ASC");
        $stmt->execute(['region' => $region]);
        $counties = $stmt->fetchAll(PDO::FETCH_COLUMN);
        if ($counties) {
            echo json_encode(['counties' => $counties]);
        } else {
            echo json_encode(['error' => 'No counties found for the selected region.']);
        }
    } else {
        echo json_encode(['error' => 'No region selected.']);
    }
} catch (PDOException $e) {
    error_log("PDOException in get_counties.php: " . $e->getMessage());
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
} catch (Exception $e) {
    error_log("Exception in get_counties.php: " . $e->getMessage());
    echo json_encode(['error' => 'An unexpected error occurred.']);
}
?>