<?php
require_once 'config.php';

header('Content-Type: application/json');

try {
    if (!isset($pdo) || !($pdo instanceof PDO)) {
        echo json_encode(['error' => 'Database connection not initialized.']);
        exit;
    }

    $subcounty = $_POST['subcounty'] ?? '';
    if ($subcounty) {
        $stmt = $pdo->prepare("SELECT institution_name, knecode, region, county, subcounty, institution_type, gender, category, accommodation_type FROM schools WHERE subcounty = :subcounty AND institution_name IS NOT NULL ORDER BY institution_name ASC");
        $stmt->execute(['subcounty' => $subcounty]);
        $schools = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if ($schools) {
            echo json_encode(['schools' => $schools]);
        } else {
            echo json_encode(['error' => 'No schools found for the selected sub-county.']);
        }
    } else {
        echo json_encode(['error' => 'No sub-county selected.']);
    }
} catch (PDOException $e) {
    error_log("PDOException in get_schools.php: " . $e->getMessage());
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
} catch (Exception $e) {
    error_log("Exception in get_schools.php: " . $e->getMessage());
    echo json_encode(['error' => 'An unexpected error occurred.']);
}
?>