<?php
require_once 'config.php';

header('Content-Type: application/json');

try {
    if (!isset($pdo) || !($pdo instanceof PDO)) {
        echo json_encode(['error' => 'Database connection not initialized.']);
        exit;
    }

    $county = $_POST['county'] ?? '';
    $region = $_POST['region'] ?? '';
    if ($county && $region) {
        $stmt = $pdo->prepare("SELECT DISTINCT subcounty FROM schools WHERE county = :county AND region = :region AND subcounty IS NOT NULL ORDER BY subcounty ASC");
        $stmt->execute(['county' => $county, 'region' => $region]);
        $subcounties = $stmt->fetchAll(PDO::FETCH_COLUMN);
        if ($subcounties) {
            echo json_encode(['subcounties' => $subcounties]);
        } else {
            echo json_encode(['error' => 'No sub-counties found for the selected county.']);
        }
    } else {
        echo json_encode(['error' => 'No county or region selected.']);
    }
} catch (PDOException $e) {
    error_log("PDOException in get_subcounties.php: " . $e->getMessage());
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
} catch (Exception $e) {
    error_log("Exception in get_subcounties.php: " . $e->getMessage());
    echo json_encode(['error' => 'An unexpected error occurred.']);
}
?>