<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Kenya Postal Codes Finder</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        :root {
            --primary-color: #1e88e5;
            --text-color: #333;
            --bg-color: #f4f6f8;
            --button-radius: 8px;
        }

        body {
            margin: 0;
            padding: 0;
            font-family: 'Segoe UI', sans-serif;
            background-color: var(--bg-color);
            color: var(--text-color);
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            height: 100vh;
            text-align: center;
        }

        h1 {
            color: var(--primary-color);
            font-size: 2.5rem;
            margin-bottom: 10px;
        }

        p {
            font-size: 1.1rem;
            margin-bottom: 30px;
            max-width: 600px;
        }

        a.button {
            background-color: var(--primary-color);
            color: white;
            padding: 12px 24px;
            border-radius: var(--button-radius);
            text-decoration: none;
            font-size: 1rem;
            transition: background 0.3s ease;
        }

        a.button:hover {
            background-color: #1565c0;
        }

        footer {
            position: absolute;
            bottom: 20px;
            font-size: 0.9rem;
            color: #999;
        }
    </style>
</head>
<body>
    <h1>Kenya Postal Codes</h1>
    <p>Search and explore postal codes, towns, and counties across Kenya with ease. This tool allows you to find any Kenyan postal code quickly and accurately.</p>
    <a href="search.php" class="button">Start Searching</a>

    <footer>&copy; 2019 - <?= date('Y') ?> Kenya Postal DB • Powered by www.nestict.net</footer>
</body>
</html>
