<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $host = $_POST['db_host'];
    $db = $_POST['db_name'];
    $user = $_POST['db_user'];
    $pass = $_POST['db_pass'];

    try {
        $pdo = new PDO("mysql:host=$host;dbname=$db", $user, $pass, [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
        ]);

        $sql = file_get_contents('kenya_postal.sql');

        // Optional: Remove any "CREATE DATABASE" or "USE" statements
        $sql = preg_replace('/CREATE DATABASE.*?;|USE .*?;/', '', $sql);

        $pdo->exec($sql);
        echo "<p style='color:green;'>✅ Installation successful. <a href='search_postal.php'>Go to search</a></p>";
    } catch (PDOException $e) {
        echo "<p style='color:red;'>❌ Installation failed: " . $e->getMessage() . "</p>";
    }
}
?>
<!DOCTYPE html>
<html>
<head><title>Install Kenya Postal DB</title></head>
<body>
<h2>Install Kenya Postal DB</h2>
<form method="POST">
    <label>DB Host:</label> <input name="db_host" value="localhost"><br>
    <label>DB Name:</label> <input name="db_name" value="nestict5_postalcodes"><br>
    <label>DB User:</label> <input name="db_user" value="nestict5_postalcodes"><br>
    <label>DB Password:</label> <input name="db_pass" type="password"><br>
    <button type="submit">Install</button>
</form>
</body>
</html>
