<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Require PHPWord library
require_once 'vendor/autoload.php';

use PhpOffice\PhpWord\TemplateProcessor;

// Define log file path
$log_file = '/home/nestict5/scripts.nestict.net/codes/debug.log';

// Initialize variables
$preview_content = '';
$error_message = '';
$success_message = '';
$client_name = '';
$client_address = '';
$client_state_country = '';
$client_signatory_name = '';
$client_signatory_title = '';
$effective_date = '';
$debug_log = [];

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Sanitize and retrieve form inputs
    $client_name = filter_input(INPUT_POST, 'client_name', FILTER_SANITIZE_STRING);
    $client_address = filter_input(INPUT_POST, 'client_address', FILTER_SANITIZE_STRING);
    $client_state_country = filter_input(INPUT_POST, 'client_state_country', FILTER_SANITIZE_STRING);
    $client_signatory_name = filter_input(INPUT_POST, 'client_signatory_name', FILTER_SANITIZE_STRING);
    $client_signatory_title = filter_input(INPUT_POST, 'client_signatory_title', FILTER_SANITIZE_STRING);
    $effective_date = filter_input(INPUT_POST, 'effective_date', FILTER_SANITIZE_STRING);
    $action = filter_input(INPUT_POST, 'action', FILTER_SANITIZE_STRING);

    // Validate inputs
    if (empty($client_name) || empty($client_address) || empty($client_state_country) || empty($effective_date)) {
        $error_message = "All required fields must be filled.";
        $debug_log[] = "Validation failed: Missing required fields";
    } else {
        // NDCA content template
        $ndca_content = "
# Non-Disclosure and Confidentiality Agreement (NDCA)

This Non-Disclosure and Confidentiality Agreement (the “Agreement”) is made and effective as of {$effective_date} (the “Effective Date”), BETWEEN:

**Nestict Infotech** (alias **Nestict Cloud Business**), a corporation organized and existing under the laws of Texas, USA, with its principal office located at 1234 Cloud Avenue, Tech City, TX 75001, USA (the “Provider”), AND:

**{$client_name}**, a corporation/individual organized and existing under the laws of {$client_state_country}, with its principal office located at {$client_address} (the “Client”).

Collectively referred to as the “Parties” and individually as a “Party.”

## RECITALS

WHEREAS, the Parties are entering into discussions regarding the provision of web hosting and related services (the “Services”) by the Provider to the Client;

WHEREAS, in connection with these Services, each Party may disclose certain proprietary and confidential information to the other Party;

WHEREAS, the Parties desire to protect such information from unauthorized use or disclosure;

NOW, THEREFORE, in consideration of the mutual covenants and agreements set forth herein, the Parties agree as follows:

## 1. Definition of Confidential Information

For purposes of this Agreement, “Confidential Information” shall include all information or material that has or could have commercial value or other utility in the business in which the Disclosing Party is engaged, including but not limited to:

- **Client Data**: Information provided by the Client, such as website content, customer data, business plans, financial details, or other proprietary information.
- **Provider Data**: Information related to Nestict Infotech’s hosting infrastructure, security protocols, proprietary technology, pricing models, or operational processes.
- Any information marked or designated as “Confidential” by the Disclosing Party, or which, under the circumstances of disclosure, should reasonably be understood to be confidential.

If Confidential Information is disclosed in written form, it shall be labeled as “Confidential.” If disclosed orally, the Disclosing Party shall indicate its confidential nature at the time of disclosure and confirm in writing within ten (10) days.

## 2. Exclusions from Confidential Information

The obligations under this Agreement do not apply to information that:

a. Is or becomes publicly known through no fault of the Receiving Party;  
b. Was in the Receiving Party’s possession prior to disclosure by the Disclosing Party;  
c. Is lawfully obtained by the Receiving Party from a third party without breach of confidentiality obligations; or  
d. Is independently developed by the Receiving Party without use of or reference to the Disclosing Party’s Confidential Information.

## 3. Obligations of the Receiving Party

The Receiving Party agrees to:

a. Limit disclosure of Confidential Information to its directors, officers, employees, agents, or representatives (collectively “Representatives”) who have a need to know such information solely for the purpose of providing or receiving the Services (the “Business Purpose”);  
b. Advise its Representatives of the confidential nature of the information and ensure they comply with this Agreement;  
c. Use a reasonable degree of care, at least equivalent to the care used to protect its own confidential information, to prevent unauthorized disclosure or use;  
d. Not disclose Confidential Information to any third party except as permitted herein or with the Disclosing Party’s prior written consent.

## 4. Permitted Disclosures

The Receiving Party may disclose Confidential Information if required by law, regulation, or a valid order of a court or governmental authority, provided that the Receiving Party:

a. Promptly notifies the Disclosing Party in writing of such requirement, to the extent permitted by law, to allow the Disclosing Party to seek a protective order or other remedy;  
b. Discloses only the portion of Confidential Information legally required; and  
c. Cooperates with the Disclosing Party’s efforts to maintain confidentiality.

## 5. Return or Destruction of Confidential Information

Upon termination of this Agreement or at the Disclosing Party’s request, the Receiving Party shall, at the Disclosing Party’s option:

a. Return all Confidential Information, including copies, to the Disclosing Party; or  
b. Destroy all Confidential Information and certify in writing that such destruction has occurred.

The Receiving Party shall not retain, make, or distribute copies of Confidential Information except as necessary to comply with legal or regulatory requirements.

## 6. Term and Duration of Confidentiality Obligations

This Agreement shall commence on the Effective Date and continue until terminated by either Party with thirty (30) days’ written notice. The obligations of confidentiality shall survive for a period of three (3) years from the date of termination, except for trade secrets, which shall remain confidential for as long as they qualify as trade secrets under applicable law.

## 7. No Rights or Licenses Granted

No rights, licenses, or ownership interests in the Confidential Information are granted to the Receiving Party under this Agreement, except for the limited right to use the Confidential Information for the Business Purpose.

## 8. Data Protection

The Provider agrees to implement reasonable and appropriate measures to secure Client Data against unauthorized access, loss, or disclosure, in compliance with applicable data protection laws, including but not limited to [GDPR/CCPA, if applicable]. The Client consents to the storage and processing of its data in the regions selected for the Services, as specified in the web hosting agreement.

## 9. No Partnership or Joint Venture

This Agreement does not create a partnership, joint venture, or agency relationship between the Parties. Neither Party has the authority to bind the other in any manner.

## 10. Governing Law and Jurisdiction

This Agreement shall be governed by and construed in accordance with the laws of Texas, USA, without regard to its conflict of laws principles. Any disputes arising under this Agreement shall be subject to the exclusive jurisdiction of the courts located in Tech City, Texas, USA.

## 11. Entire Agreement

This Agreement constitutes the entire understanding between the Parties with respect to the subject matter herein and supersedes all prior agreements, whether written or oral. This Agreement may only be amended in writing signed by both Parties.

## 12. Notices

Any notices required under this Agreement shall be in writing and delivered to the addresses listed above, either by certified mail, courier, or email with confirmation of receipt.

## 13. Breach and Remedies

In the event of a breach of this Agreement, the Disclosing Party shall be entitled to seek equitable relief, including injunctions, in addition to any other remedies available at law. The Receiving Party shall notify the Disclosing Party immediately upon discovery of any unauthorized use or disclosure of Confidential Information.

## IN WITNESS WHEREOF

The Parties have executed this Agreement as of the Effective Date.

**Nestict Infotech**  
By: _____________________________  
Name: John Doe  
Title: CEO  
Date: {$effective_date}

**{$client_name}**  
By: _____________________________  
Name: {$client_signatory_name}  
Title: {$client_signatory_title}  
Date: {$effective_date}
";

        if ($action === 'preview') {
            // Display preview
            $preview_content = nl2br(htmlspecialchars($ndca_content));
            $success_message = "Preview generated successfully.";
            $debug_log[] = "Preview generated for client: $client_name";
        } elseif ($action === 'download') {
            try {
                // Generate and download .docx
                $template = new TemplateProcessor('template.docx'); // Assumes a blank .docx template exists

                // Replace placeholders in the NDCA template
                $template->setValue('DATE', htmlspecialchars($effective_date));
                $template->setValue('CLIENT_NAME', htmlspecialchars($client_name));
                $template->setValue('CLIENT_ADDRESS', htmlspecialchars($client_address));
                $template->setValue('CLIENT_STATE_COUNTRY', htmlspecialchars($client_state_country));
                $template->setValue('CLIENT_SIGNATORY_NAME', htmlspecialchars($client_signatory_name));
                $template->setValue('CLIENT_SIGNATORY_TITLE', htmlspecialchars($client_signatory_title));
                $template->setValue('NESTICT_ADDRESS', '1234 Cloud Avenue, Tech City, TX 75001, USA');
                $template->setValue('NESTICT_STATE_COUNTRY', 'Texas, USA');
                $template->setValue('SIGNATORY_NAME', 'John Doe');
                $template->setValue('SIGNATORY_TITLE', 'CEO');

                // Save the document
                $filename = 'NDCA_' . str_replace(' ', '_', $client_name) . '_' . date('Ymd') . '.docx';
                $template->saveAs($filename);

                // Force download
                header('Content-Type: application/vnd.openxmlformats-officedocument.wordprocessingml.document');
                header('Content-Disposition: attachment;filename="' . basename($filename) . '"');
                header('Cache-Control: max-age=0');
                readfile($filename);
                unlink($filename); // Delete file after download
                $debug_log[] = "NDCA downloaded: $filename";
                exit;
            } catch (Exception $e) {
                $error_message = "Error generating document: " . $e->getMessage();
                $debug_log[] = "Document generation error: " . $e->getMessage();
            }
        }
    }

    // Write debug log
    if (!empty($debug_log)) {
        file_put_contents($log_file, implode("\n", $debug_log) . "\n", FILE_APPEND);
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Generate NDCA - Nestict Cloud Business</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-color: #2c3e50;
            --secondary-color: #3498db;
            --bg-color: #f5f7fa;
            --card-bg: #ffffff;
            --text-color: #2c3e50;
            --border-radius: 12px;
            --shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
            --success-color: #27ae60;
            --error-color: #e74c3c;
        }

        [data-theme="dark"] {
            --bg-color: #1a1e24;
            --card-bg: #2c2f36;
            --text-color: #ecf0f1;
            --shadow: 0 4px 15px rgba(0, 0, 0, 0.3);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, var(--bg-color) 0%, #e0e7f0 100%);
            color: var(--text-color);
            min-height: 100vh;
            padding: 80px 20px 40px;
            transition: var(--transition);
        }

        .navbar {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            background: linear-gradient(90deg, var(--primary-color), var(--secondary-color));
            box-shadow: var(--shadow);
            padding: 15px 20px;
            z-index: 1000;
        }

        .navbar-container {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .navbar-brand {
            font-size: 1.8rem;
            font-weight: 700;
            color: #fff;
            text-decoration: none;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .nav-menu {
            display: flex;
            gap: 20px;
            align-items: center;
        }

        .nav-menu a {
            color: #fff;
            text-decoration: none;
            font-size: 1.1rem;
            font-weight: 500;
            transition: var(--transition);
            padding: 5px 10px;
            border-radius: 6px;
        }

        .nav-menu a:hover {
            background: rgba(255, 255, 255, 0.2);
            color: #fff;
        }

        .hamburger {
            display: none;
            flex-direction: column;
            cursor: pointer;
            background: none;
            border: none;
            padding: 5px;
        }

        .hamburger span {
            width: 25px;
            height: 3px;
            background: #fff;
            margin: 3px 0;
            transition: var(--transition);
        }

        .theme-toggle {
            position: fixed;
            top: 20px;
            right: 20px;
            background: rgba(255, 255, 255, 0.1);
            border: none;
            font-size: 24px;
            cursor: pointer;
            color: #fff;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 1001;
            transition: var(--transition);
        }

        .theme-toggle:hover {
            background: rgba(255, 255, 255, 0.3);
        }

        h2 {
            color: var(--primary-color);
            margin-bottom: 25px;
            font-size: 2.5rem;
            font-weight: 700;
            text-align: center;
            text-transform: uppercase;
            letter-spacing: 2px;
        }

        .container {
            max-width: 800px;
            margin: 0 auto;
            width: 100%;
        }

        .form-section {
            background: var(--card-bg);
            padding: 20px;
            border-radius: var(--border-radius);
            box-shadow: var(--shadow);
            margin-bottom: 30px;
        }

        .form-group {
            margin-bottom: 15px;
        }

        label {
            display: block;
            margin-bottom: 5px;
            font-weight: 500;
            color: var(--text-color);
        }

        input[type="text"], input[type="date"] {
            padding: 12px;
            font-size: 1rem;
            border: none;
            border-radius: var(--border-radius);
            box-shadow: var(--shadow);
            background: var(--card-bg);
            color: var(--text-color);
            transition: var(--transition);
            width: 100%;
        }

        input[type="text"]:focus, input[type="date"]:focus {
            outline: none;
            box-shadow: 0 0 10px rgba(52, 152, 219, 0.5);
        }

        .button-group {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
            justify-content: center;
        }

        button {
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            color: #fff;
            border: none;
            padding: 12px 30px;
            font-size: 1rem;
            font-weight: 600;
            border-radius: var(--border-radius);
            cursor: pointer;
            transition: var(--transition);
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        button:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow);
        }

        button.reset-btn {
            background: linear-gradient(45deg, #7f8c8d, #95a5a6);
        }

        .message {
            text-align: center;
            margin-bottom: 20px;
            font-weight: 500;
            padding: 10px;
            border-radius: var(--border-radius);
        }

        .success {
            background: rgba(39, 174, 96, 0.1);
            color: var(--success-color);
        }

        .error {
            background: rgba(231, 76, 60, 0.1);
            color: var(--error-color);
        }

        .preview-container {
            background: var(--card-bg);
            padding: 20px;
            border-radius: var(--border-radius);
            box-shadow: var(--shadow);
            margin-top: 20px;
        }

        .preview-container h2 {
            font-size: 1.8rem;
            margin-bottom: 15px;
        }

        .preview-container pre {
            white-space: pre-wrap;
            font-family: 'Inter', sans-serif;
            font-size: 1rem;
            color: var(--text-color);
        }

        @media print {
            .navbar, .theme-toggle, .form-section, .button-group {
                display: none;
            }
            body {
                padding: 20px;
                background: #fff;
            }
            .preview-container {
                display: block !important;
                box-shadow: none;
            }
            .container {
                max-width: 100%;
            }
        }

        @media (max-width: 768px) {
            .nav-menu {
                display: none;
                flex-direction: column;
                position: absolute;
                top: 60px;
                left: 0;
                right: 0;
                background: linear-gradient(90deg, var(--primary-color), var(--secondary-color));
                padding: 20px;
                box-shadow: var(--shadow);
                border-radius: 0 0 var(--border-radius) var(--border-radius);
            }

            .nav-menu.active {
                display: flex;
            }

            .hamburger {
                display: flex;
            }

            .form-section, .preview-container {
                padding: 15px;
            }

            h2 {
                font-size: 2rem;
            }

            .button-group {
                flex-direction: column;
                align-items: center;
            }

            button {
                width: 100%;
                margin-bottom: 10px;
            }
        }

        @media (max-width: 480px) {
            h2 {
                font-size: 1.8rem;
            }

            input[type="text"], input[type="date"], button {
                font-size: 1rem;
            }

            .navbar-brand {
                font-size: 1.5rem;
            }
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="navbar-container">
            <a href="/" class="navbar-brand">Nestict Cloud Business</a>
            <button class="hamburger" onclick="toggleMenu()">
                <span></span>
                <span></span>
                <span></span>
            </button>
            <div class="nav-menu" id="nav-menu">
                <a href="/services">Services</a>
                <a href="/about">About</a>
                <a href="/contact">Contact</a>
            </div>
        </div>
    </nav>
    <button class="theme-toggle" onclick="toggleTheme()">🌙</button>
    <div class="container">
        <h2>Generate NDCA</h2>
        <?php if ($success_message): ?>
            <p class="message success"><?= htmlspecialchars($success_message) ?></p>
        <?php endif; ?>
        <?php if ($error_message): ?>
            <p class="message error"><?= htmlspecialchars($error_message) ?></p>
        <?php endif; ?>
        <div class="form-section">
            <form method="POST">
                <div class="form-group">
                    <label for="client_name">Client Name *</label>
                    <input type="text" id="client_name" name="client_name" value="<?php echo htmlspecialchars($client_name); ?>" required>
                </div>
                <div class="form-group">
                    <label for="client_address">Client Address *</label>
                    <input type="text" id="client_address" name="client_address" value="<?php echo htmlspecialchars($client_address); ?>" required>
                </div>
                <div class="form-group">
                    <label for="client_state_country">State/Country *</label>
                    <input type="text" id="client_state_country" name="client_state_country" value="<?php echo htmlspecialchars($client_state_country); ?>" required>
                </div>
                <div class="form-group">
                    <label for="client_signatory_name">Signatory Name *</label>
                    <input type="text" id="client_signatory_name" name="client_signatory_name" value="<?php echo htmlspecialchars($client_signatory_name); ?>" required>
                </div>
                <div class="form-group">
                    <label for="client_signatory_title">Signatory Title</label>
                    <input type="text" id="client_signatory_title" name="client_signatory_title" value="<?php echo htmlspecialchars($client_signatory_title); ?>">
                </div>
                <div class="form-group">
                    <label for="effective_date">Effective Date *</label>
                    <input type="date" id="effective_date" name="effective_date" value="<?php echo htmlspecialchars($effective_date); ?>" required>
                </div>
                <div class="button-group">
                    <button type="submit" name="action" value="preview">Preview</button>
                    <?php if ($preview_content): ?>
                        <button type="submit" name="action" value="download">Download NDCA</button>
                    <?php endif; ?>
                    <button type="button" class="reset-btn" onclick="resetForm()">Reset</button>
                </div>
            </form>
        </div>
        <?php if ($preview_content): ?>
            <div class="preview-container">
                <h2>NDCA Preview</h2>
                <pre><?php echo $preview_content; ?></pre>
            </div>
        <?php endif; ?>
    </div>

    <script>
        function toggleTheme() {
            const body = document.body;
            const currentTheme = body.getAttribute('data-theme');
            body.setAttribute('data-theme', currentTheme === 'dark' ? 'light' : 'dark');
            localStorage.setItem('theme', body.getAttribute('data-theme'));
        }

        function toggleMenu() {
            const menu = document.getElementById('nav-menu');
            menu.classList.toggle('active');
        }

        function resetForm() {
            window.location.href = window.location.pathname;
        }

        document.addEventListener('DOMContentLoaded', function() {
            const savedTheme = localStorage.getItem('theme') || 'light';
            document.body.setAttribute('data-theme', savedTheme);
        });
    </script>
</body>
</html>